import { PropType } from 'vue';
export type Level = 'L' | 'M' | 'Q' | 'H';
export type RenderAs = 'canvas' | 'svg';
export type ImageSettings = {
    src: string;
    x?: number;
    y?: number;
    height: number;
    width: number;
    excavate?: boolean;
};
export declare const QrcodeSvg: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>> & Readonly<{}>, {
    value: string;
    size: number;
    level: Level;
    background: string;
    foreground: string;
    margin: number;
    imageSettings: ImageSettings;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
export declare const QrcodeCanvas: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>> & Readonly<{}>, {
    value: string;
    size: number;
    level: Level;
    background: string;
    foreground: string;
    margin: number;
    imageSettings: ImageSettings;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
declare const QrcodeVue: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
    renderAs: {
        type: PropType<RenderAs>;
        required: boolean;
        default: string;
        validator: (as: any) => boolean;
    };
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    renderAs: {
        type: PropType<RenderAs>;
        required: boolean;
        default: string;
        validator: (as: any) => boolean;
    };
    value: {
        type: StringConstructor;
        required: boolean;
        default: string;
    };
    size: {
        type: NumberConstructor;
        default: number;
    };
    level: {
        type: PropType<Level>;
        default: "L";
        validator: (l: any) => boolean;
    };
    background: {
        type: StringConstructor;
        default: string;
    };
    foreground: {
        type: StringConstructor;
        default: string;
    };
    margin: {
        type: NumberConstructor;
        required: boolean;
        default: number;
    };
    imageSettings: {
        type: PropType<ImageSettings>;
        required: boolean;
        default: () => {};
    };
}>> & Readonly<{}>, {
    value: string;
    size: number;
    level: Level;
    background: string;
    foreground: string;
    margin: number;
    imageSettings: ImageSettings;
    renderAs: RenderAs;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
export default QrcodeVue;
