"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const laravel_mix_1 = __importDefault(require("laravel-mix"));
const Component_1 = require("laravel-mix/src/components/Component");
const webpack_1 = require("webpack");
const loader_1 = require("./loader.cjs");
class BeforeBuildPlugin {
    constructor(callback) {
        this.callback = callback;
    }
    apply(compiler) {
        compiler.hooks.compile.tap('BeforeBuildPlugin', this.callback);
    }
}
laravel_mix_1.default.extend('i18n', class extends Component_1.Component {
    register(langPath = 'lang') {
        this.langPath = this.context.paths.rootPath + path_1.default.sep + langPath + path_1.default.sep;
        this.frameworkLangPath =
            this.context.paths.rootPath +
                path_1.default.sep +
                'vendor/laravel/framework/src/Illuminate/Translation/lang/'.replace('/', path_1.default.sep);
    }
    webpackConfig(config) {
        let files = [];
        config.watchOptions = {
            ignored: /php.*\.json/
        };
        if ((0, loader_1.hasPhpTranslations)(this.langPath)) {
            config.plugins.push(new webpack_1.EnvironmentPlugin({
                LARAVEL_VUE_I18N_HAS_PHP: true
            }));
        }
        config.plugins.push(new BeforeBuildPlugin(() => {
            files = (0, loader_1.generateFiles)(this.langPath, [...(0, loader_1.parseAll)(this.frameworkLangPath), ...(0, loader_1.parseAll)(this.langPath)]);
        }));
        this.context.listen('build', () => {
            files.forEach((file) => {
                if (fs_1.default.existsSync(this.langPath + file.name)) {
                    fs_1.default.unlinkSync(this.langPath + file.name);
                }
            });
            if (fs_1.default.existsSync(this.langPath) && fs_1.default.readdirSync(this.langPath).length < 1) {
                fs_1.default.rmdirSync(this.langPath);
            }
        });
    }
});
//# sourceMappingURL=mix.cjs.map